/*
 * Decompiled with CFR 0.152.
 */
package jeresources.util;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import jeresources.entry.VillagerEntry;
import jeresources.registry.VillagerRegistry;
import jeresources.util.LogHelper;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraftforge.registries.ForgeRegistries;

public class VillagersHelper {
    public static void initRegistry(VillagerRegistry reg) {
        for (VillagerProfession profession : ForgeRegistries.PROFESSIONS) {
            try {
                reg.addVillagerEntry(new VillagerEntry(profession, VillagersHelper.getTrades(profession)));
            }
            catch (Exception e) {
                LogHelper.warn("Failed loading villager {} registered at {}", profession.toString(), profession.getRegistryName().toString());
                LogHelper.warn("Exception caught when registering villager", e);
            }
        }
    }

    private static Int2ObjectMap<VillagerTrades.ItemListing[]> getTrades(VillagerProfession profession) {
        return VillagerTrades.f_35627_.getOrDefault(profession, Int2ObjectMaps.emptyMap());
    }
}

